# Computer Science 4752 - Assignment 1
# David Churchill
#
# All code you will write for this assingment goes in this file. It is imported by
# A1_main.py and A1_test.py 


import sys              # used for file reading
from settings import *  # use a separate file for all the constant settings

# the class we will use to store the map, and make calls to path finding
class Grid:
    # set up all the default values for the frid and read in the map from a given file
    def __init__(self, filename):
        # 2D list that will hold all of the grid tile information 
        self.__grid = []
        self.__load_data(filename)
        self.__width, self.__height = len(self.__grid), len(self.__grid[0])

    # loads the grid data from a given file name
    def __load_data(self, filename):
        # turn each line in the map file into a list of integers
        temp_grid = [list(map(int,line.strip())) for line in open(filename, 'r')]
        # transpose the input since we read it in as (y, x) 
        self.__grid = [list(i) for i in zip(*temp_grid)]

    # return the cost of a given action
    # note: this only works for actions in our LEGAL_ACTIONS defined set (8 directions)
    def __get_action_cost(self, action):
        return CARDINAL_COST if (action[0] == 0 or action[1] == 0) else DIAGONAL_COST 

    
    def get(self, tile): 
    ### returns the tile type of a given tile (int, int) on the map ###
        return self.__grid[tile[0]][tile[1]]

    def width(self):
    ### returns the width of the grid (x-direction) ###
         return self.__width

    def height(self): 
    ### returns the width of the grid (x-direction) ###
        return self.__height

    # Student TODO: Implement this function
    def is_connected(self, start, goal, size):
        ### 
        # This function should compute and return the optimal path between the start
        # state (x,y) and the goal state (x,y). 
        #
        # Args:
        #    start (int, int): tuple representing the start state
        #    goal  (int, int): tuple representing the goal state 
        #    size  (int)     : the size of the path-finding object
        #
        # Returns:
        #    bool : whether or not a path exists for an object of size size between 
        #           the start state and the goal state
        ###
        return True

    # Student TODO: Replace this function with your A* implementation
    def get_path(self, start, goal, size):
        ### 
        # This function should compute and return the optimal path between the start
        # tile (x,y) and the goal (x,y) tile. 
        #
        # Args:
        #    start (int, int): tuple representing the start state
        #    goal  (int, int): tuple representing the goal state 
        #    size  (int)     : the size of the path-finding object
        # Returns:
        #    (path, path_cost, expanded) tuple
        #    path      (list): list of (int,int) action tuples representing the computed 
        #                      path from the start state to the goal state
        #    path_cost (int) :
        ###
        path = []
        action = (1 if start[0] <= goal[0] else -1, 1 if start[1] <= goal[1] else -1)
        d = (abs(start[0] - goal[0]), abs(start[1] - goal[1]))
        # add the diagonal actions until we hit the row or column of the goal tile
        for diag in range(d[1] if d[0] > d[1] else d[0]):
            path.append(action)
        # add the remaining straight actions to reach the goal tile
        for straight in range(d[0]-d[1] if d[0] > d[1] else d[1]-d[0]):
            path.append((action[0], 0) if d[0]>d[1] else (0, action[1]))
        # return the path, the cost of the path, and the set of expanded nodes (for A*)
        return path, sum(map(self.__get_action_cost, path)), set()

    # Student TODO: Replace this function with a better (but admissible) heuristic
    #
    # This function should compute and return an admissible heuristic for moving
    # from the start (x,y) location to the goal (x,y) location. A heuristic value
    # of 1 for every path means that A* will perform like Dijkstra's algorithm. It
    # is recommended to leave this value as 1 until you get your A* code working.
    #
    # Inputs:    
    #    start - (x,y) tuple representing the start state
    #    goal  - (x,y) tuple representing the goal state
    # Outputs:
    #    A computed heuristic between start and goal (must be admissible)   
    def estimate_cost(self, start, goal):
        return 1

# Student TODO: You should implement AStar as a separate class
#               This will help keep things modular

# Student TODO: You should implement a separate Node class
#               AStar search should use these Nodes in its open and closed lists
